/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.integrator.VWCMAdminNode;
import filenet.vw.apps.taskman.integrator.VWManagerUtil;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWCMAdminInfoPanel
extends VWTaskTabPanel {
    VWCMAdminNode m_node = null;
    JTextField m_userName = null;
    JPasswordField m_password = null;
    JLabel m_iconLabel = null;
    JTextField m_ceURI = null;
    VWManagerUtil m_util = new VWManagerUtil(0);

    public VWCMAdminInfoPanel(VWCMAdminNode cmNode) {
        this.m_node = cmNode;
        this.initLayout();
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.fill = 0;
        gbConst.anchor = 23;
        gbConst.gridwidth = 1;
        gbConst.gridheight = 1;
        gbConst.weightx = 0.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(4, 10, 0, 0);
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        this.m_iconLabel = new JLabel(this.m_node.getIcon32(), 2);
        this.add((Component)this.m_iconLabel, gbConst);
        gbConst.fill = 2;
        gbConst.weightx = 1.0;
        gbConst.gridy = 0;
        gbConst.gridx = 1;
        gbConst.insets = new Insets(15, 10, 0, 0);
        gbConst.gridwidth = 0;
        this.add((Component)new JLabel(VWResource.ComponentManagers), gbConst);
        VWTaskUtil.updateComponentOrientation(this);
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 10, 5, 5);
        this.m_ceURI = new JTextField("");
        this.m_ceURI.setName(VWResource.ContentEngineURI);
        this.m_ceURI.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_ceURI.getName() + ":"), VWTaskPropertyPanel.LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_ceURI, (Object)VWTaskPropertyPanel.FIELD_CONSTRAINTS, true);
        this.m_userName = new JTextField("");
        this.m_userName.setName(VWResource.ServiceUserName);
        this.m_userName.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_userName.getName() + ":"), VWTaskPropertyPanel.LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_userName, (Object)VWTaskPropertyPanel.FIELD_CONSTRAINTS, true);
        this.m_password = new JPasswordField("");
        this.m_password.setName(VWResource.ServicePassword);
        this.m_password.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_password.getName() + ":"), VWTaskPropertyPanel.LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_password, (Object)VWTaskPropertyPanel.FIELD_CONSTRAINTS, true);
        gbConst.gridx = 0;
        gbConst.gridy = 1;
        gbConst.fill = 1;
        gbConst.gridwidth = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        VWTaskUtil.updateComponentOrientation(panel);
        this.add((Component)panel, gbConst);
    }

    public void applyProperties() {
        try {
            this.m_node.setCEURI(this.m_ceURI.getText().trim());
            this.m_node.setOptions(this.m_util.getEString(this.m_userName.getText().trim(), new String(this.m_password.getPassword())));
        }
        catch (Exception e) {
            VWDebug.logException(e, "Error applying user name and password.");
        }
    }

    public void resetProperties() {
        this.m_ceURI.setText(this.m_node.getCEURI());
        String userName = null;
        String password = null;
        try {
            VWAuthItem item = this.m_util.getDString(this.m_node.getOptions());
            if (item != null) {
                userName = item.getName();
                password = item.getPassword();
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        if (userName == null) {
            userName = "";
        } else if (userName.compareTo("\"\"") == 0) {
            userName = "";
        }
        if (password == null) {
            password = "";
        } else if (password.compareTo("\"\"") == 0) {
            password = "";
        }
        this.m_userName.setText(userName);
        this.m_password.setText(password);
    }

    protected String getOptions() throws Exception {
        return this.m_util.getEString(this.m_userName.getText().trim(), new String(this.m_password.getPassword()));
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:39:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }
}

